% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liver.R
\name{peld}
\alias{peld}
\title{PELD score}
\usage{
peld(INR, bili, albumin, listing_age, growth_failure, units = "SI")
}
\arguments{
\item{INR}{INR}

\item{bili}{serum biliruin (µmol/l)}

\item{albumin}{serum albumin (g/l)}

\item{listing_age}{age at the time of listing (years; integer or decimal)}

\item{growth_failure}{whether there is growth failure (1 = yes, 0 = no)}

\item{units}{units used for bilirubin ("SI" for µmol/l (default), "US" for mg/dl)}
}
\value{
numeric vector of PELD scores
}
\description{
A vectorised function to generate a PELD score for paediatric liver transplant candidates.
The default unit for bilirubin is µmol/l and albumin in g/l, but these can be changed to
mg/dl and g/dl respectively by setting the
optional units parameter to "US".
}
\details{
Some labs report albumin in g/dl rather than the g/l used in this function.
If units are set to "US" then g/dl is assumed and albumin should be divided by 10 if the
lab reports are in g/l. If using SI units,
take care to
multiply the lab albumin by 10 if the lab output is in g/dl.

Reference: McDiarmid SV, Anand R, Lindblad AS, et. al. Development of a pediatric end-stage
liver disease score to predict poor outcome in children awaiting liver transplantation.
Transplantation 2002; 74(2):173-81.
}
\examples{
peld(INR = 2, bili = 54, albumin = 25, listing_age = 2, growth_failure = 1)
peld(INR = 2, bili = 3.1, albumin = 25, listing_age = 2, growth_failure = 1, units = "US")
}
