% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nankivell_walser.R
\name{nankivell_US}
\alias{nankivell_US}
\title{eGFR using Nankivell formula (US units)}
\usage{
nankivell_US(SCr, Urea, Weight, Height, Sex)
}
\arguments{
\item{SCr}{numeric vector of serum creatinine in µmol/l (or mg/dl if units = "US")}

\item{Urea}{numeric vector of serum urea in mmol/l (or BUN in mg/dl if units = "US")}

\item{Weight}{numeric vector of patient weights in kilograms}

\item{Height}{numeric vector of patient heights in centimetres}

\item{Sex}{character vector of sex ("F" for female, "M" for male)}
}
\value{
a numeric vector of eGFR values
}
\description{
A wrapper function for the nankivell() vectorised function to calculate eGFR using the Nankivell
formula, but using creatinine and BUN in mg/dl rather than international units. It has not been
possible to run automated tests to confirm the
accuracy of this function, so please use with caution.
}
\details{
Reference: Nankivell BJ, Gruenwald SM, Allen RD, Chapman JR: Predicting glomerular filtration rate
after renal transplantation. Transplantation 1995; 59:1683-89.
}
\examples{
nankivell_US(SCr = 1.33, Urea = 13.4, Weight = 65, Height = 172, Sex = "M") # 44.55
}
