% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liver_scores.R
\name{liver_dri}
\alias{liver_dri}
\title{Liver Donor Risk Index (DRI)}
\usage{
liver_dri(age, cod, eth, dcd, split, share, cit, height)
}
\arguments{
\item{age}{numeric vector of patient ages in years}

\item{cod}{character string vector of donor causes of death, one of "trauma", "anoxia", "cva" or "other"}

\item{eth}{character string vector of ethnicity, one of "black", "white" or "other"}

\item{dcd}{numeric vector of whether DCD (1 = yes, 0 = no)}

\item{split}{numeric vector of whether liver split (1 = yes, 0 = no)}

\item{share}{character string vector of type of sharing, one of "regional" or "national"}

\item{cit}{numeric vector of cold ischaemic times in hours}

\item{height}{numeric vector of patient heights in cm}
}
\value{
numeric vector of liver DRI values
}
\description{
A vectorised function to calculate the Liver Donor Risk Index as published by Feng and others.
}
\details{
Reference: Feng S, Goodrich NP, Bragg-Gresham JL et al. Characteristics Associated with
Liver Graft Failre: The Concept of a Donor Risk Index.
American Journal of Transplantation 2006; 6:783-790.
}
\examples{
liver_dri(age = 25, cod = "trauma", eth = "white", dcd = 0, split = 0,
    share = "local", cit = 8, height = 170) # 1.00

liver_dri(age = 64, cod = "cva", eth = "white", dcd = 0, split = 0,
    share = "local", cit = 14, height = 170) # 1.88
}
