% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liver_scores.R
\name{et_dri}
\alias{et_dri}
\title{Eurotransplant Donor Risk Index in Liver Transplantation (ET-DRI)}
\usage{
et_dri(age, cod, dcd, split, share, cit, ggt, rescue)
}
\arguments{
\item{age}{numeric vector of patient ages in years}

\item{cod}{character string vector of donor causes of death, one of "trauma", "anoxia", "cva" or "other"}

\item{dcd}{numeric vector of whether DCD (1 = yes, 0 = no)}

\item{split}{numeric vector of whether liver split (1 = yes, 0 = no)}

\item{share}{character string vector of type of sharing, one of "local", regional" or "national"}

\item{cit}{numeric vector of cold ischaemic times in hours}

\item{ggt}{numeric vector of last pre-transplant serum gamma-GT level in IU/l}

\item{rescue}{numeric vector of whether rescue transplant (1 = yes, 0 = no)}
}
\value{
numeric vector of ET-DRI scores
}
\description{
A vectorised function to calculate the Eurotransplant Donor Risk Index for liver transplantation.
The ET-DRI is a variant of the American DRI published by Feng et al but adapted to the European
population. The American liver DRI is available using the transplantr::liver_dri() function.
}
\details{
Reference: Braat AE, Blok JJ, Putter H, et al. The Eurotransplant Donor Risk Index in Liver
Transplantation: ET-DRI. American Journal of Transplantation 2012; 12:2789–2796.
}
\examples{
et_dri(age = 39, cod = "trauma", dcd = 0, split = 0, share = "local",
    cit = 8, ggt = 50, rescue = 0) # 1.00

et_dri(age = 25, cod = "cva", dcd = 0, split = 0, share = "local",
    cit = 8, ggt = 50, rescue = 0) # 1.15
}
