% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_alasso.R
\name{trans_alasso}
\alias{trans_alasso}
\title{Adaptive LASSO for Semiparametric Transformation Models.}
\usage{
trans_alasso(Z, Y, delta_i, r, lamb_vec, solu = TRUE)
}
\arguments{
\item{Z}{the baseline covariates}

\item{Y}{observed event times}

\item{delta_i}{censoring indicator. If \eqn{Y} is censored, \code{delta_i}=0. If not, \code{delta_i}=1.}

\item{r}{parameter in transformation function}

\item{lamb_vec}{the grad of the tuning parameter \eqn{\lambda}}

\item{solu}{determines whether the solution path will be plotted. The default is TRUE.}
}
\value{
a list containing
\tabular{lccl}{
  \code{beta_res} \tab\tab\tab the estimated \eqn{\beta} with the selected tuning parameter \eqn{\lambda} \cr
  \code{GCV_res} \tab\tab\tab the value of GCV  with the selected tuning parameter \eqn{\lambda} \cr
  \code{lamb_res} \tab\tab\tab the selected tuning parameter \eqn{\lambda} \cr
  \code{beta_all} \tab\tab\tab estimated \eqn{\beta} with all tuning parameters \cr
  \code{CSV_all} \tab\tab\tab value of GCV  with all tuning parameters \cr
  \code{skip_para} \tab\tab\tab a list containing the \eqn{\lambda} and the number of adaptive lasso iteration when adaptive lasso doesn't work. \cr
}
}
\description{
Select the important variables in semiparametric transformation
 models for right censored data using adaptive lasso.
}
\details{
The initial value of the coefficient \eqn{\beta} used as the adapting
 weights is EM estimator, which is computed by the function \code{EM_est}.
 The tuning parameter \eqn{\lambda} is data-dependent and we select it using
 generalized crossvalidation. There may be some errors for small
 \eqn{\lambda}, in which case the \eqn{\lambda} and the number of adaptive
 lasso iteration are recorded in the \code{skip_para}.
}
\examples{


 if(!requireNamespace("MASS", quietly = TRUE))
 {stop("package MASS needed for this example. Please install it.")}

 gen_lasdat = function(n,r,rho,beta_true,a,b,seed=66,std = FALSE)
{

  set.seed(seed)
  beta_len = length(beta_true)
  beta_len = beta_len
  sigm = matrix(0, nrow = beta_len, ncol = beta_len)
  for(i in 1:(beta_len-1))
  {
    diag(sigm[1:(beta_len+1-i),i:beta_len]) = rho^(i-1)
  }
  sigm[1,beta_len] = rho^(beta_len-1)
  sigm[lower.tri(sigm)] = t(sigm)[lower.tri(sigm)]

  Z = MASS::mvrnorm(n, mu = rep(0, beta_len), Sigma = sigm)
  beta_Z.true = c(Z \%*\% beta_true)
  U = runif(n)
  if(r>0)
  {
    t = ((U^(-r)-1)/(a*r*exp(beta_Z.true)))^(1/b)
  }else if(r == 0)
  {
    t = (-log(U)/(a*exp(beta_Z.true)))^(1/b)
    #t = (exp(-log(U)/(0.5 * exp(beta_Z.true))) - 1)
  }
  C = runif(n,0,8)
  Y = pmin(C,t)
  delta_i = ifelse( C >= t, 1, 0)
  if(std)
  {
    Z = apply(Z,2,normalize)
  }
  return(list(Z = Z, Y = Y, delta_i = delta_i,censor = mean(1-delta_i)))
}

now_rep=1
dat = gen_lasdat(100,1,0.5,c(0.3,0.5,0.7,0,0,0,0,0,0,0),2,5,seed= 6+60*now_rep,std = FALSE)
Z = dat$Z
Y = dat$Y
delta_i = dat$delta_i

tra_ala = trans_alasso(Z,Y,delta_i,lamb_vec = c(5,7),r=1)
tra_ala$GCV_res
tra_ala$beta_res
tra_ala$lamb_res


}
\references{
Xiaoxi, L. , & Donglin, Z. . (2013). Variable selection in
 semiparametric transformation models for right-censored data. Biometrika(4),
 859-876.
}
