% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text-io.R
\name{text_read}
\alias{text_read}
\alias{text_write}
\title{Read and Write Text}
\usage{
text_read(path = "", encoding = "UTF-8")

text_write(x = character(), path = "", encoding = "UTF-8")
}
\arguments{
\item{path}{A non-empty and non-NA character string. A path to a file to
read text from, or write text to.}

\item{encoding}{A non-empty and non-NA character string. The source character
encoding. In almost all cases, this should be UTF-8. Other encodings are
internally re-encoded to UTF-8 for portability.}

\item{x}{A character vector. Lines of text to write. Its current encoding is
given by \code{encoding}.}
}
\value{
\code{\link[=text_read]{text_read()}} returns a character vector.

\code{\link[=text_write]{text_write()}} returns \code{NULL}, invisibly.
}
\description{
\code{\link[=text_read]{text_read()}} and \code{\link[=text_write]{text_write()}} respectively wrap \code{\link[base:readLines]{base::readLines()}} and
\code{\link[base:writeLines]{base::writeLines()}}. They further validate their arguments, normalize
file paths and re-encode inputs to \code{UTF-8} before reading and writing.
}
\seealso{
\code{\link[=readLines]{readLines()}},
\code{\link[=writeLines]{writeLines()}},
\code{\link[=iconv]{iconv()}}
}
\keyword{internal}
