% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.trajClusters.R
\name{plot.trajClusters}
\alias{plot.trajClusters}
\alias{scatterplots}
\alias{CVIplot}
\title{Plot \code{trajClusters} object}
\usage{
\method{plot}{trajClusters}(x, sample.size = 5, ask = TRUE, which.plots = NULL, ...)

scatterplots(x, ask = TRUE, ...)

CVIplot(x, ...)
}
\arguments{
\item{x}{object of class \code{trajClusters} as returned by the function
\code{trajClusters()}.}

\item{sample.size}{the number of random trajectories to be randomly sampled
from each cluster. Defaults to \code{5}.}

\item{ask}{logical. If \code{TRUE}, the user is asked before each plot. Defaults to
\code{TRUE}.}

\item{which.plots}{either \code{NULL} or a vector of integers. If \code{NULL}, every
available plot is displayed. If a vector is supplied, only the corresponding
plots will be displayed.}

\item{...}{other parameters to be passed through to plotting functions.}
}
\description{
Plots the curves corresponding to (or closest to) the centroids of the clusters and plots a random sample from each groups.
}
\examples{
\dontrun{
data("trajdata")
trajdata.noGrp <- trajdata[, -which(colnames(trajdata) == "Group")] #remove the Group column

m = trajMeasures(trajdata.noGrp, ID = TRUE)
c3 = trajClusters(m, nclusters = 3)

plot(c3)

#The pointwise mean trajectories correspond to the third and fourth displayed plots.

c4 = trajClusters(m, nclusters = 4)

plot(c4, which.plots = 3:4)

}


}
