% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{lottr}
\alias{lottr}
\title{Calculate LOTTR Metric Score}
\usage{
lottr(travel_time_readings = NULL, monthly = FALSE, verbose = FALSE)
}
\arguments{
\item{travel_time_readings}{path to RITIS export CSV with 15-minute average readings for all vehicles}

\item{monthly}{TRUE or FALSE specifies if the results should be
aggregated by month. If FALSE scores will be computed by TMC for all
data in the input file.}

\item{verbose}{Provide diagnostic output and return all calculated values (necessary for \code{\link{hpms}} function)}
}
\value{
A data.table of LOTTR scores by TMC
}
\description{
Calculate LOTTR given a RITIS NPMRDS export of travel time data.
Data is passed in as the path to the csv containing the travel time readings.\
Travel time units must be seconds and averaging should be 15 minutes.
}
\examples{
\dontrun{
lottr("data/All_Vehicles/Readings.csv")
lottr("data/All_Vehicles/Readings.csv", monthly = TRUE)
}

}
