% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blankcorrect.R
\name{blankcorrect}
\alias{blankcorrect}
\title{Blank correct response variable}
\usage{
blankcorrect(
  dataset,
  Conc,
  blank_group = "Blank",
  Response,
  list_obj = NULL,
  quiet = FALSE
)
}
\arguments{
\item{dataset}{A dataframe, containing the columns `Conc` and `Response`.}

\item{Conc}{Bare (unquoted) column name in `dataset` that groups the
`Response` variable.}

\item{blank_group}{Character. Name of the `Conc` level to calculate the
correction value from.}

\item{Response}{Bare (unquoted) column name in `dataset` containing
the response variable.}

\item{list_obj}{Optional. List object used for integration with
[runtoxdrc()].}

\item{quiet}{Logical. Indicates if results should be hidden. Defaults
to FALSE.}
}
\value{
A modified `dataset` with an additional column, `c_response`. If
 `list_obj` is provided, returns this within a list as
 `list_obj$dataset`, along with statistics of the correction value as
 `list_obj$blank_stats`.
}
\description{
`blankcorrect()` subtracts a calculated correction value
  from all responses.
}
\examples{
blankcorrect(
     dataset = toxresult,
     Conc = Conc,
     blank_group = "Blank",
     Response = RFU
   )

}
