% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collection-rf100-underwater.R
\name{rf100_underwater_collection}
\alias{rf100_underwater_collection}
\title{RoboFlow 100 Underwater dataset Collection}
\usage{
rf100_underwater_collection(
  dataset,
  split = c("train", "test", "valid"),
  transform = NULL,
  target_transform = NULL,
  download = FALSE
)
}
\arguments{
\item{dataset}{Dataset to select within \code{c("pipes", "aquarium", "objects", "coral")}.}

\item{split}{the subset of the dataset to choose between \code{c("train", "test", "valid")}.}

\item{transform}{Optional transform function applied to the image.}

\item{target_transform}{Optional transform function applied to the target.}

\item{download}{Logical. If TRUE, downloads the dataset if not present at \code{root}.}
}
\value{
A torch dataset. Each element is a named list with:
\itemize{
\item \code{x}: H x W x 3 array representing the image.
\item \code{y}: a list containing the target with:
\itemize{
\item \code{image_id}: numeric identifier of the x image.
\item \code{labels}: numeric identifier of the N bounding-box object class.
\item \code{boxes}: a torch_tensor of shape (N, 4) with bounding boxes, each in \eqn{(x_{min}, y_{min}, x_{max}, y_{max})} format.
}
}

The returned item inherits the class \code{image_with_bounding_box} so it can be
visualised with helper functions such as \code{\link[=draw_bounding_boxes]{draw_bounding_boxes()}}.
}
\description{
Loads one of the \href{https://universe.roboflow.com/browse/documents}{RoboFlow 100 Underwater} datasets: "pipes",
"aquarium", "objects", or "coral". Images are provided with COCO-style
bounding box annotations for object detection tasks.
}
\examples{
\dontrun{
ds <- rf100_underwater_collection(
  dataset = "objects",
  split = "train",
  transform = transform_to_tensor,
  download = TRUE
)

item <- ds[1]
boxed <- draw_bounding_boxes(item)
tensor_image_browse(boxed)
}

}
\seealso{
Other detection_dataset: 
\code{\link{coco_detection_dataset}()},
\code{\link{pascal_voc_datasets}},
\code{\link{rf100_biology_collection}()},
\code{\link{rf100_damage_collection}()},
\code{\link{rf100_document_collection}()},
\code{\link{rf100_infrared_collection}()},
\code{\link{rf100_medical_collection}()}
}
\concept{detection_dataset}
