% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset-rf100-peixos.R
\name{rf100_peixos_segmentation_dataset}
\alias{rf100_peixos_segmentation_dataset}
\title{RF100 Peixos Segmentation Dataset}
\usage{
rf100_peixos_segmentation_dataset(
  split = c("train", "test", "valid"),
  root = tempdir(),
  download = FALSE,
  transform = NULL,
  target_transform = NULL
)
}
\arguments{
\item{split}{the subset of the dataset to choose between \code{c("train", "test", "valid")}.}

\item{root}{directory path to download the dataset.}

\item{download}{Logical. If TRUE, downloads the dataset if not present at \code{root}.}

\item{transform}{Optional transform function applied to the image.}

\item{target_transform}{Optional transform function applied to the target.}
}
\value{
A torch dataset. Each element is a named list with:
\itemize{
\item \code{x}: H × W × 3 array (use \code{transform_to_tensor()} in \code{transform} to get
C × H × W tensor).
\item \code{y}: a list with:
\itemize{
\item \code{masks}: boolean tensor of shape (1, H, W).
\item \code{labels}: integer vector with the class index (always 1 for "fish").
}
}

The returned item is given class \code{image_with_segmentation_mask} so it can be
visualised with helpers like \code{\link[=draw_segmentation_masks]{draw_segmentation_masks()}}.
}
\description{
Loads the Roboflow 100 "peixos" dataset for semantic segmentation.
"peixos" contains 3 splits of respectively 821 / 118 / 251 color images of size 640 x 640.
Segmentation masks are generated on-the-fly from polygon
annotations of the unique "fish" category.
}
\examples{
\dontrun{
ds <- rf100_peixos_segmentation_dataset(
  split = "train",
  transform = transform_to_tensor,
  download = TRUE
)
item <- ds[1]
overlay <- draw_segmentation_masks(item)
tensor_image_browse(overlay)
}

}
\seealso{
Other segmentation_dataset: 
\code{\link{oxfordiiitpet_segmentation_dataset}()},
\code{\link{pascal_voc_datasets}}
}
\concept{segmentation_dataset}
