% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models-faster_rcnn.R
\name{model_fasterrcnn}
\alias{model_fasterrcnn}
\alias{model_fasterrcnn_resnet50_fpn}
\alias{model_fasterrcnn_resnet50_fpn_v2}
\alias{model_fasterrcnn_mobilenet_v3_large_fpn}
\alias{model_fasterrcnn_mobilenet_v3_large_320_fpn}
\title{Faster R-CNN Models}
\usage{
model_fasterrcnn_resnet50_fpn(
  pretrained = FALSE,
  progress = TRUE,
  num_classes = 91,
  ...
)

model_fasterrcnn_resnet50_fpn_v2(
  pretrained = FALSE,
  progress = TRUE,
  num_classes = 91,
  ...
)

model_fasterrcnn_mobilenet_v3_large_fpn(
  pretrained = FALSE,
  progress = TRUE,
  num_classes = 91,
  ...
)

model_fasterrcnn_mobilenet_v3_large_320_fpn(
  pretrained = FALSE,
  progress = TRUE,
  num_classes = 91,
  ...
)
}
\arguments{
\item{pretrained}{Logical. If TRUE, loads pretrained weights from local file.}

\item{progress}{Logical. Show progress bar during download (unused).}

\item{num_classes}{Number of output classes (default: 91 for COCO).}

\item{...}{Other arguments (unused).}
}
\value{
A \code{fasterrcnn_model} nn_module.
}
\description{
Construct Faster R-CNN model variants for object detection tasks.
}
\section{Functions}{
\itemize{
\item \code{model_fasterrcnn_resnet50_fpn()}: Faster R-CNN with ResNet-50 FPN

\item \code{model_fasterrcnn_resnet50_fpn_v2()}: Faster R-CNN with ResNet-50 FPN V2

\item \code{model_fasterrcnn_mobilenet_v3_large_fpn()}: Faster R-CNN with MobileNet V3 Large FPN

\item \code{model_fasterrcnn_mobilenet_v3_large_320_fpn()}: Faster R-CNN with MobileNet V3 Large 320 FPN

}}
\section{Task}{

Object detection over images with bounding boxes and class labels.


Object detection over images with bounding boxes and class labels.
}

\section{Input Format}{

Input images should be \code{torch_tensor}s of shape
\verb{(batch_size, 3, H, W)} where \code{H} and \code{W} are typically around 800.
}

\section{Available Models}{

\itemize{
\item \code{model_fasterrcnn_resnet50_fpn()}
\item \code{model_fasterrcnn_resnet50_fpn_v2()}
\item \code{model_fasterrcnn_mobilenet_v3_large_fpn()}
\item \code{model_fasterrcnn_mobilenet_v3_large_320_fpn()}
}
}

\examples{
\dontrun{
library(magrittr)
norm_mean <- c(0.485, 0.456, 0.406) # ImageNet normalization constants, see
# https://pytorch.org/vision/stable/models.html
norm_std  <- c(0.229, 0.224, 0.225)
# Use a publicly available image of an animal
wmc <- "https://upload.wikimedia.org/wikipedia/commons/thumb/"
url <- "e/ea/Morsan_Normande_vache.jpg/120px-Morsan_Normande_vache.jpg"
img <- base_loader(paste0(wmc,url))

input <- img \%>\%
  transform_to_tensor() \%>\%
  transform_resize(c(520, 520)) \%>\%
  transform_normalize(norm_mean, norm_std)
batch <- input$unsqueeze(1)    # Add batch dimension (1, 3, H, W)

# ResNet-50 FPN
model <- model_fasterrcnn_resnet50_fpn(pretrained = TRUE)
model$eval()
pred <- model(batch)$detections
num_boxes <- as.integer(pred$boxes$size()[1])
keep <- seq_len(min(5, num_boxes))
boxes <- pred$boxes[keep, ]$view(c(-1, 4))
labels <- ds$category_names[as.character(as.integer(pred$labels[keep]))]
if (num_boxes > 0) {
  boxed <- draw_bounding_boxes(image, boxes, labels = labels)
  tensor_image_browse(boxed)
}

# ResNet-50 FPN V2
model <- model_fasterrcnn_resnet50_fpn_v2(pretrained = TRUE)
model$eval()
pred <- model(batch)$detections
num_boxes <- as.integer(pred$boxes$size()[1])
keep <- seq_len(min(5, num_boxes))
boxes <- pred$boxes[keep, ]$view(c(-1, 4))
labels <- ds$category_names[as.character(as.integer(pred$labels[keep]))]
if (num_boxes > 0) {
  boxed <- draw_bounding_boxes(image, boxes, labels = labels)
  tensor_image_browse(boxed)
}

# MobileNet V3 Large FPN
model <- model_fasterrcnn_mobilenet_v3_large_fpn(pretrained = TRUE)
model$eval()
pred <- model(batch)$detections
num_boxes <- as.integer(pred$boxes$size()[1])
keep <- seq_len(min(5, num_boxes))
boxes <- pred$boxes[keep, ]$view(c(-1, 4))
labels <- ds$category_names[as.character(as.integer(pred$labels[keep]))]
if (num_boxes > 0) {
  boxed <- draw_bounding_boxes(image, boxes, labels = labels)
  tensor_image_browse(boxed)
}

# MobileNet V3 Large 320 FPN
model <- model_fasterrcnn_mobilenet_v3_large_320_fpn(pretrained = TRUE)
model$eval()
pred <- model(batch)$detections
num_boxes <- as.integer(pred$boxes$size()[1])
keep <- seq_len(min(5, num_boxes))
boxes <- pred$boxes[keep, ]$view(c(-1, 4))
labels <- ds$category_names[as.character(as.integer(pred$labels[keep]))]
if (num_boxes > 0) {
  boxed <- draw_bounding_boxes(image, boxes, labels = labels)
  tensor_image_browse(boxed)
}
}

}
\seealso{
Other object_detection_model: 
\code{\link{model_facenet}}
}
\concept{object_detection_model}
