% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset-flickr.R
\name{flickr_caption_dataset}
\alias{flickr_caption_dataset}
\alias{flickr8k_caption_dataset}
\alias{flickr30k_caption_dataset}
\title{Flickr Caption Datasets}
\usage{
flickr8k_caption_dataset(
  root = tempdir(),
  train = TRUE,
  transform = NULL,
  target_transform = NULL,
  download = FALSE
)

flickr30k_caption_dataset(
  root = tempdir(),
  train = TRUE,
  transform = NULL,
  target_transform = NULL,
  download = FALSE
)
}
\arguments{
\item{root}{Character. Root directory where the dataset will be stored under \code{root/flickr30k}.}

\item{train}{: If \code{TRUE}, loads the training set. If \code{FALSE}, loads the test set. Default is \code{TRUE}.}

\item{transform}{Optional function to transform input images after loading. Default is \code{NULL}.}

\item{target_transform}{Optional function to transform labels. Default is \code{NULL}.}

\item{download}{Logical. Whether to download the dataset if not found locally. Default is \code{FALSE}.}
}
\value{
A torch dataset of class \code{flickr8k_caption_dataset}.
Each element is a named list:
\itemize{
\item \code{x}: a H x W x 3 integer array representing an RGB image.
\item \code{y}: a character vector containing all five captions associated with the image.
}

A torch dataset of class \code{flickr30k_caption_dataset}.
Each element is a named list:
\itemize{
\item \code{x}: a H x W x 3 integer array representing an RGB image.
\item \code{y}: a character vector containing all five captions associated with the image.
}
}
\description{
Flickr8k Dataset
}
\details{
The Flickr8k and Flickr30k collections are \strong{image captionning} datasets
composed of 8,000 and 30,000 color images respectively, each paired with five
human-annotated captions. The images are in RGB format with varying spatial
resolutions, and these datasets are widely used for training and evaluating
vision-language models.
}
\examples{
\dontrun{
# Load the Flickr8k caption dataset
flickr8k <- flickr8k_caption_dataset(download = TRUE)

# Access the first item
first_item <- flickr8k[1]
first_item$x  # image array with shape {3, H, W}
first_item$y  # character vector containing five captions.

# Load the Flickr30k caption dataset
flickr30k <- flickr30k_caption_dataset(download = TRUE)

# Access the first item
first_item <- flickr30k[1]
first_item$x  # image array with shape {3, H, W}
first_item$y  # character vector containing five captions.
}

}
\seealso{
Other caption_dataset: 
\code{\link{coco_caption_dataset}()}
}
\concept{caption_dataset}
