% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_lu_solve}
\alias{torch_lu_solve}
\title{Lu_solve}
\usage{
torch_lu_solve(self, LU_data, LU_pivots)
}
\arguments{
\item{self}{(Tensor) the RHS tensor of size \eqn{(*, m, k)}, where \eqn{*}                is zero or more batch dimensions.}

\item{LU_data}{(Tensor) the pivoted LU factorization of A from \code{torch_lu} of size \eqn{(*, m, m)},                       where \eqn{*} is zero or more batch dimensions.}

\item{LU_pivots}{(IntTensor) the pivots of the LU factorization from \code{torch_lu} of size \eqn{(*, m)},                           where \eqn{*} is zero or more batch dimensions.                           The batch dimensions of \code{LU_pivots} must be equal to the batch dimensions of                           \code{LU_data}.}
}
\description{
Lu_solve
}
\section{lu_solve(input, LU_data, LU_pivots, out=NULL) -> Tensor }{


Returns the LU solve of the linear system \eqn{Ax = b} using the partially pivoted
LU factorization of A from \code{torch_lu}.
}

\examples{
if (torch_is_installed()) {
A = torch_randn(c(2, 3, 3))
b = torch_randn(c(2, 3, 1))
out = torch_lu(A)
x = torch_lu_solve(b, out[[1]], out[[2]])
torch_norm(torch_bmm(A, x) - b)
}
}
