% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dag.R
\name{arrange}
\alias{arrange}
\title{Arrange agents into hierarchy}
\usage{
arrange(tally)
}
\arguments{
\item{tally}{a \code{toporanga tally} object.}
}
\value{
A \code{toporanga_graph} object, representing the established graph.
}
\description{
Estimate agent hierarchy from a tally by assembling edges in order of decreasing weight and skipping cycle-creating ones.
The effect is a directed acyclic graph that can be topologically-sorted into an agent order, though this order may not be unique depending on how well the latent hierarchy is sampled and whether it even exists.
}
\note{
The method may be stochastic if there are ties in weights.
}
\examples{
data(EcoHAB)
arrange(tally_log(EcoHAB$winner,EcoHAB$loser))
}
