% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topic_diagnostics.R
\name{topic_diagnostics}
\alias{topic_diagnostics}
\title{Calculate diagnostics for each topic in a topic model}
\usage{
topic_diagnostics(
  topic_model,
  dtm_data,
  top_n_tokens = 10,
  method = c("gamma_threshold", "largest_gamma"),
  gamma_threshold = 0.2
)
}
\arguments{
\item{topic_model}{a fitted topic model object from one of the following:
\code{\link[topicmodels]{tm-class}}}

\item{dtm_data}{a document-term matrix of token counts coercible to \code{slam_triplet_matrix}
where each row is a document, each column is a token,
and each entry is the frequency of the token in a given document}

\item{top_n_tokens}{an integer indicating the number of top words to consider for mean token length}

\item{method}{a string indicating which method to use -
"gamma_threshold" or "largest_gamma"}

\item{gamma_threshold}{a number between 0 and 1 indicating the gamma threshold to be used
when using the gamma threshold method, the default is 0.2}
}
\value{
A dataframe where each row is a topic and each column contains
the associated diagnostic values
}
\description{
Generate a dataframe containing the diagnostics for each topic in a topic model
}
\examples{

# Using the example from the LDA function
library(topicmodels)
data("AssociatedPress", package = "topicmodels")
lda <- LDA(AssociatedPress[1:20,], control = list(alpha = 0.1), k = 2)
topic_diagnostics(lda, AssociatedPress[1:20,])
}
\references{
{
  Jordan Boyd-Graber, David Mimno, and David Newman, 2014.
  \emph{Care and Feeding of Topic Models: Problems, Diagnostics, and Improvements.}
  CRC Handbooks ofModern Statistical Methods. CRC Press, Boca Raton, Florida.
}
}
