% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_df.R
\name{read_toon_df}
\alias{read_toon_df}
\title{Read tabular TOON to data.frame}
\usage{
read_toon_df(
  file,
  key = NULL,
  strict = TRUE,
  allow_comments = TRUE,
  allow_duplicate_keys = TRUE,
  warn = TRUE,
  col_types = NULL,
  ragged_rows = c("expand_warn", "error"),
  n_mismatch = c("warn", "error"),
  max_extra_cols = Inf
)
}
\arguments{
\item{file}{Character scalar. Path to TOON file.}

\item{key}{Character scalar or NULL. If non-NULL, extract tabular array at
root[key] (root must be object).}

\item{strict}{Logical. If TRUE (default), enforce strict TOON syntax.}

\item{allow_comments}{Logical. If TRUE (default), allow # and // comments.}

\item{allow_duplicate_keys}{Logical. If TRUE (default), allow duplicate keys.}

\item{warn}{Logical. If TRUE (default), emit warnings for schema changes.}

\item{col_types}{Named character vector specifying column types:
"logical", "integer", "double", or "character".}

\item{ragged_rows}{Character. How to handle rows with different field counts:
\itemize{
\item "expand_warn" (default): Fill missing fields with NA, expand schema
for extra fields, emit aggregated warning.
\item "error": Require all rows have same field count.
}}

\item{n_mismatch}{Character. How to handle declared row count mismatch:
\itemize{
\item "warn" (default): Accept mismatch, return observed rows, emit warning.
\item "error": Require observed row count equals declared [N].
}}

\item{max_extra_cols}{Numeric. Maximum new columns allowed via schema expansion.
Default Inf (no limit).}
}
\value{
A base data.frame.
}
\description{
Read tabular TOON to data.frame
}
\examples{
\dontrun{
# Read tabular TOON file
df <- read_toon_df("data.toon")

# Read nested tabular array
df <- read_toon_df("config.toon", key = "records")
}

}
