% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toml.R
\name{as_toml}
\alias{as_toml}
\alias{toml}
\title{Create Toml objects}
\usage{
as_toml(x, df_as_array = TRUE)

toml(..., df_as_array = TRUE)
}
\arguments{
\item{x}{a named list}

\item{df_as_array}{default \code{TRUE}. Creates an array of tables from a \code{data.frame}.
When \code{FALSE}, creates a single table with an array for each column in the data.frame.}

\item{...}{named items to be serialized to TOML.}
}
\value{
an object of class \code{Toml}
}
\description{
Use \code{as_toml()} to convert a named list to a \code{Toml} object.
Or, create a \code{Toml} object by passing in named values to \code{toml()}.
}
\details{
If you are serializing a \code{data.frame} to a single table with \code{df_as_array = FALSE},
note that \strong{missing values are omitted} when serializing a vector to an array as there is no
concept of missing values in TOML.
}
\examples{
toml(person = list(age = 30L, name = "Wilma"))

as_toml(
  list(
    person = list(age = 30L, name = "Wilma")
  )
)
}
