% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{import_onehot}
\alias{import_onehot}
\title{Import One-Hot Data}
\usage{
import_onehot(
  data,
  cols,
  actor,
  session,
  window_size = 1L,
  window_type = "tumbling",
  aggregate = FALSE
)
}
\arguments{
\item{data}{A \code{data.frame} in wide format.}

\item{cols}{An \code{expression} giving a tidy selection of columns to be
considered as one-hot data.}

\item{actor}{An optional \code{character} string giving the column name of
\code{data} containing the actor identifiers.}

\item{session}{An optional \code{character} string giving the column name of
\code{data} containing the session identifiers.}

\item{window_size}{An \code{integer} specifying the window size for grouping.}

\item{window_type}{A \code{character} string. Either \code{"tumbling"} (the default)
for non-overlapping windows or \code{"sliding"} for one-step sliding window.}

\item{aggregate}{A \code{logical} value that determines how multiple occurrences
of the same event within a window are processed. Option \code{TRUE} aggregates
multiple occurrences into a single occurrence. Option \code{FALSE} keeps
all occurrences (the default).}
}
\value{
The processed data as a \code{data.frame}.
}
\description{
Import One-Hot Data
}
\examples{
d <- data.frame(
  actor = gl(100, 5),
  session = gl(10, 50),
  feature1 = rbinom(500, 1, prob = 0.33),
  feature2 = rbinom(500, 1, prob = 0.25),
  feature3 = rbinom(500, 1, prob = 0.50)
)
onehot1 <- import_onehot(d, feature1:feature3)
onehot2 <- import_onehot(d, feature1:feature3, "actor", "session")

}
\seealso{
Other data: 
\code{\link{import_data}()},
\code{\link{prepare_data}()},
\code{\link{print.tna_data}()},
\code{\link{simulate.group_tna}()},
\code{\link{simulate.tna}()}
}
\concept{data}
