#' Extensions to 'tmap' with Two New Modes: 'mapbox' and 'maplibre'
#'
#' The 'tmap' package provides two plotting modes for static and interactive
#' thematic maps. This package extends 'tmap' with two additional modes based
#' on 'mapbox' <https://mapbox.com> and 'maplibre' <https://maplibre.org>.
#' These modes feature interactive vector tiles, globe views, and other modern
#' web-mapping capabilities, while using the same 'tmap' syntax for creating
#' maps (Tennekes 2018, <doi:10.32614/RJ-2018-027>).
#'
#' @author Martijn Tennekes \email{mtennekes@gmail.com}
#' @import data.table
#' @concept GIS
#' @concept thematic maps
#' @concept statistical maps
#' @concept choropleth
#' @concept bubble map
#' @example examples/mapbox.R
"_PACKAGE"
