% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixed_person.R
\name{fix_person}
\alias{fix_person}
\title{Fixed Person Calibration with or without Covariate}
\usage{
fix_person(df, theta, model = c("Rasch", "2PL"), covariate = NULL)
}
\arguments{
\item{df}{A data frame of item responses (0/1). Columns represent items, rows represent persons.}

\item{theta}{A numeric vector of person abilities (fixed parameters). Must match the number of rows in \code{df}.}

\item{model}{A character string specifying the model type. Options are "Rasch" or "2PL".}

\item{covariate}{An optional numeric vector representing a person-level covariate (e.g., time, group).
Defaults to \code{NULL}.}
}
\value{
A data frame containing:
\itemize{
\item Item statistics (difficulty, standard errors, z-values, p-values).
\item Discrimination parameters (for 2PL model).
\item Global covariate effect (if \code{covariate} is provided).
\item Classical item statistics (p-value, count, point-biserial correlation).
\item Mean theta per item (average ability of persons answering the item).
\item Infit and Outfit statistics (for Rasch model only).
}
}
\description{
Estimates item parameters (difficulty, discrimination) given fixed person parameters (theta),
with an optional person-level covariate. Supports Rasch and 2-Parameter Logistic models.
}
\examples{
  # --- Example: With Selected Package Data ---
  data("ela1", package = "tirt")

  # Subset data for a manageable example
  # Select the first 500 examinees and 30 item responses
  df_real <- ela1[1:500, 1:30]

  # Extract pre-estimated latent traits and covariates
  fixed_theta <- ela1$THETA[1:500]
  fixed_cov <- ela1$COVARIATE[1:500]

  # Estimate item parameters given fixed ability levels
  # fitting a 2-parameter logistic (2PL) model
  real_res <- fix_person(df = df_real,
                                   theta = fixed_theta,
                                   model = "2PL",
                                   covariate = fixed_cov)
  head(real_res)
\donttest{
  # --- Example: With Package Data ---
  data("ela1", package = "tirt")

  # Select Item Responses (Cols 1-30)
  df_real <- ela1[, 1:30]

  fixed_theta <- ela1$THETA
  fixed_cov <- ela1$COVARIATE

  real_res <- fix_person(df = df_real,
                                   theta = fixed_theta,
                                   model = "2PL",
                                   covariate = fixed_cov)
  head(real_res)
}
}
