% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roadmap.R
\name{roadmap}
\alias{roadmap}
\title{Create a roadmap}
\usage{
roadmap(
  conf_data,
  start_data,
  start_method = NULL,
  schema = NULL,
  visit_sequence = NULL,
  replicates = NULL,
  constraints = NULL
)
}
\arguments{
\item{conf_data}{A \code{data.frame} of confidential data.}

\item{start_data}{A \code{data.frame} of starting data used to initialize the process.}

\item{start_method}{An optional \code{start_method} object.}

\item{schema}{An optional \code{schema} object.}

\item{visit_sequence}{An optional \code{visit_sequence} object.}

\item{replicates}{An optional \code{replicates} object.}

\item{constraints}{An optional \code{constraints} object.}
}
\value{
A new \code{roadmap} object.
}
\description{
A \code{roadmap} is a container object that aggregates information required to
specify the order of operations for synthesis modeling and sampling steps.
}
\details{
Users initiate a roadmap object with \code{conf_data} and \code{start_data}. All other
objects will either be completed with defaults or specified interactively via
the provided API.
}
\examples{
roadmap(
  conf_data = acs_conf_nw,
  start_data = acs_start_nw,
  start_method = start_method(
    start_func = start_resample, n = 1000
  )
) 


}
