% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enforce_custom_na.R
\name{enforce_custom_na}
\alias{enforce_custom_na}
\title{Redefine \code{NA} value for a dataset.}
\usage{
enforce_custom_na(data, col_schema)
}
\arguments{
\item{data}{A \code{data.frame} object}

\item{col_schema}{A col_schema from a \code{schema} object}
}
\value{
A \code{data.frame}
}
\description{
Redefine \code{NA} value for a dataset.
}
\examples{

# create custom NA filter
example_na_custom <- example_na |>
  tidyr::replace_na(
    list("wages" = -999)
  )

example_na_expanded_custom <- enforce_custom_na(
  data = example_na_custom,
  col_schema = list(
    "wages" = list(
      dtype = "dbl",
      na_value = -999
     )
   )
 )

}
