% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_var.R
\name{add_var}
\alias{add_var}
\title{Prepare variables for add_summary}
\usage{
add_var(data, var = NULL, group = "group", norm = "auto", center = "median")
}
\arguments{
\item{data}{A data frame containing the variables to analyze, with variables at columns and observations at rows.}

\item{var}{A character vector of variable names to include. If \code{NULL}, by default, all columns except the \code{group} column will be used.}

\item{group}{A character string specifying the grouping variable in \code{data}. If not specified, \code{'group'}, by default.}

\item{norm}{Control parameter for normality tests. Accepts:
\itemize{
\item \code{'auto'}: Automatically decide based on p-values, but the same as \code{'ask'} when n > 1000, default
\item \code{'ask'}: Show p-values, plots QQ plots and prompts for decision
\item \code{TRUE}/\code{'true'}: Always assuming data are normally distributed
\item \code{FALSE}/\code{'false'}: Always assuming data are non-normally distributed
}}

\item{center}{A character string specifying the \code{center} to use in Levene's test for equality of variances. Default is \code{'median'}, which is more robust than the mean.}
}
\value{
A modified data frame with an attribute \code{'add_var'} containing a list of categorized variables and their properties:
\itemize{
\item \code{var}: List of categorized variables:
\itemize{
\item \code{valid}: All valid variable names after checks
\item \code{continuous}: Sublist of continuous variables (further divided by normality/equal variance)
\item \code{categorical}: Sublist of categorical variables (further divided by ordered/expected frequency)
}
\item \code{group}: Grouping variable name
\item \code{overall_n}: Total number of observations
\item \code{group_n}: Observation counts per group
\item \code{group_nlevels}: Number of groups
\item \code{group_levels}: Group level names
\item \code{norm}: Normality check method used
}
}
\description{
This function processes a dataset for statistical analysis by categorizing variables into continuous and categorical types. It automatically handles normality checks, equality of variances checks, and expected frequency assumptions checks.
}
\examples{
data <- add_var(iris, var = c("Sepal.Length", "Species"), group = "Species")

}
