% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec_abs2trans.R
\name{spec_abs2trans}
\alias{spec_abs2trans}
\title{Convert Absorbance Data to Transmittance}
\usage{
spec_abs2trans(.data, wn_col = NULL)
}
\arguments{
\item{.data}{A `data.frame` or `tibble` containing spectral data in absorbance.}

\item{wn_col}{A character string specifying the column name for the wavelength data. Default is `"Wn"`.}
}
\value{
A `tibble` with the converted transmittance data, containing the wavelength column and the numeric transmittance columns. Any rows with infinite values are removed.
}
\description{
This function converts absorbance data to transmittance using the formula \eqn{T = 10^{(2 - A)}}, where \eqn{A} is the absorbance and \eqn{T} is the transmittance.
}
