% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/answer_as_text.R
\name{answer_as_text}
\alias{answer_as_text}
\title{Make LLM answer as a constrained text response}
\usage{
answer_as_text(
  prompt,
  max_words = NULL,
  max_characters = NULL,
  add_instruction_to_prompt = TRUE
)
}
\arguments{
\item{prompt}{A single string or a \code{\link[=tidyprompt]{tidyprompt()}} object}

\item{max_words}{(optional) Maximum number of words allowed in the response.
If specified, responses exceeding this limit will fail validation}

\item{max_characters}{(optional) Maximum number of characters allowed in the response.
If specified, responses exceeding this limit will fail validation}

\item{add_instruction_to_prompt}{(optional) Add instruction for replying
within the constraints to the prompt text. Set to FALSE for debugging if
extractions/validations are working as expected (without instruction the
answer should fail the validation function, initiating a retry)}
}
\value{
A \code{\link[=tidyprompt]{tidyprompt()}} with an added \code{\link[=prompt_wrap]{prompt_wrap()}} which
will ensure that the LLM response conforms to the specified constraints
}
\description{
Make LLM answer as a constrained text response
}
\examples{
\dontrun{
  "What is a large language model?" |>
    answer_as_text(max_words = 10) |>
    send_prompt()
  # --- Sending request to LLM provider (llama3.1:8b): ---
  # What is a large language model?
  #
  # You must provide a text response. The response must be at most 10 words.
  # --- Receiving response from LLM provider: ---
  # A type of AI that processes and generates human-like text.
  # [1] "A type of AI that processes and generates human-like text."
}
}
\seealso{
Other pre_built_prompt_wraps: 
\code{\link{add_image}()},
\code{\link{add_text}()},
\code{\link{answer_as_boolean}()},
\code{\link{answer_as_category}()},
\code{\link{answer_as_integer}()},
\code{\link{answer_as_json}()},
\code{\link{answer_as_list}()},
\code{\link{answer_as_multi_category}()},
\code{\link{answer_as_named_list}()},
\code{\link{answer_as_regex_match}()},
\code{\link{answer_by_chain_of_thought}()},
\code{\link{answer_by_react}()},
\code{\link{answer_using_r}()},
\code{\link{answer_using_sql}()},
\code{\link{answer_using_tools}()},
\code{\link{prompt_wrap}()},
\code{\link{quit_if}()},
\code{\link{set_system_prompt}()}

Other answer_as_prompt_wraps: 
\code{\link{answer_as_boolean}()},
\code{\link{answer_as_category}()},
\code{\link{answer_as_integer}()},
\code{\link{answer_as_json}()},
\code{\link{answer_as_list}()},
\code{\link{answer_as_multi_category}()},
\code{\link{answer_as_named_list}()},
\code{\link{answer_as_regex_match}()}
}
\concept{answer_as_prompt_wraps}
\concept{pre_built_prompt_wraps}
