% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_openai.R
\name{openai_embedding}
\alias{openai_embedding}
\title{Generate Embeddings Using OpenAI API}
\usage{
openai_embedding(
  .input,
  .model = "text-embedding-3-small",
  .truncate = TRUE,
  .timeout = 120,
  .dry_run = FALSE,
  .max_tries = 3,
  .verbose = FALSE
)
}
\arguments{
\item{.input}{An existing LLMMessage object (or a character vector of texts to embed)}

\item{.model}{The embedding model identifier (default: "text-embedding-3-small").}

\item{.truncate}{Whether to truncate inputs to fit the model's context length (default: TRUE).}

\item{.timeout}{Timeout for the API request in seconds (default: 120).}

\item{.dry_run}{If TRUE, perform a dry run and return the request object.}

\item{.max_tries}{Maximum retry attempts for requests (default: 3).}

\item{.verbose}{Should information about current ratelimits be printed? (default: FALSE)}
}
\value{
A tibble with two columns: \code{input} and \code{embeddings}.
The \code{input} column contains the texts sent to embed, and the \code{embeddings} column
is a list column where each row contains an embedding vector of the sent input.
}
\description{
Generate Embeddings Using OpenAI API
}
