% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LLMMessage.R
\name{LLMMessage}
\alias{LLMMessage}
\title{Large Language Model Message Class}
\usage{
LLMMessage(message_history = list(), system_prompt = character(0))
}
\arguments{
\item{message_history}{A list containing messages. Each message is a named list with keys like \code{role}, \code{content}, \code{media}, etc.}

\item{system_prompt}{A character string representing the default system prompt used for the conversation.}
}
\description{
\code{LLMMessage} is an S7 class for managing a conversation history intended for use with large language models (LLMs). Please use
\code{llm_message()}to create or modify \code{LLMMessage} objects.
}
\details{
The \code{LLMMessage} class includes the following features:
\itemize{
\item Stores message history in a structured format.
\item Supports attaching media and metadata to messages.
\item Provides generics like \code{add_message()}, \code{has_image()}, and \code{remove_message()} for interaction.
\item Enables API-specific formatting through the \code{to_api_format()} generic.
\item \code{message_history}: A list containing messages. Each message is a named list with keys like \code{role}, \code{content}, \code{media}, etc.
\item \code{system_prompt}: A character string representing the default system prompt used for the conversation.
}
}
