% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.tidygam}
\alias{plot.tidygam}
\title{Plot methods for tidygam objects}
\usage{
\method{plot}{tidygam}(x, series = NULL, comparison = NULL, raster_interp = FALSE, ...)
}
\arguments{
\item{x}{A \code{tidygam} object (see \code{\link[=predict_gam]{predict_gam()}}).}

\item{series}{A string specifying the variable that corresponds to the series
to be plotted on the $x$-axis. If a string is given, the other numeric
variables in the model are set to their mean value, unless specific values
are given in \code{values}. If a character vector of two strings is given, the
two variables will be taken as the elements of a tensor product smooth.
This allows the user to plot 2D raster plots.}

\item{comparison}{Name of a categorical predictor to compare as a string.}

\item{raster_interp}{Whether to linearly interpolate when plotting a tensor
product smooth/interaction. It makes sense only when \code{series} has two
variables. The default is \code{FALSE}.}

\item{...}{Arguments passed to \code{plot()}.}
}
\value{
A \code{ggplot} object.
}
\description{
Plotting methods for \code{tidygam} objects.
}
\examples{
library(mgcv)
set.seed(10)
sim_data <- gamSim(4)

model_1 <- gam(y ~ s(x2, by = fac) + s(x0), data = sim_data)

preds_1 <- predict_gam(model_1, length_out = 50, exclude_terms = "s(x0)")
plot(preds_1, "x2")

preds_2 <- predict_gam(model_1, length_out = 100, values = list(x0 = 0))
plot(preds_2, "x2", "fac")
library(ggplot2)
plot(preds_2, "x2", "fac") +
  scale_fill_brewer(type = "qual") +
  scale_color_brewer(type = "qual")

# Plotting tensor product smooths/interactions
model_2 <- gam(y ~ te(x0, x2, by = fac), data = sim_data)
preds_3 <- predict_gam(model_2)
preds_3 \%>\% plot(series = c("x0", "x2"), comparison = "fac")
}
