% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temperature-indices.R
\name{calculate_CSDI}
\alias{calculate_CSDI}
\title{Calculate Cold Spell Duration Index (CSDI)}
\usage{
calculate_CSDI(
  df,
  frequency = "daily",
  time_col = NULL,
  tmin_col = NULL,
  temp_col = NULL,
  window_days = 30,
  min_consecutive = 6
)
}
\arguments{
\item{df}{Data frame with climate data}

\item{frequency}{Temporal frequency: "daily" or "hourly" (string)}

\item{time_col}{Name of the time column (string). For daily frequency, the column should be
of class Date or a string in the format YYYY-MM-DD. For hourly frequency, the column
should be of class POSIXct or a string in the format YYYY-MM-DD HH:MM:SS.}

\item{tmin_col}{Name of minimum temperature column (daily data) (string)}

\item{temp_col}{Name of temperature column (for single temp or hourly) (string)}

\item{window_days}{Window size for percentile calculation (default: 30)}

\item{min_consecutive}{Minimum consecutive days for cold spell (default: 6)}
}
\value{
A tibble with columns: year, CSDI, n_spells, mean_spell_length
}
\description{
Calculates the number of days with at least 6 consecutive days
where temperature is below the 10th percentile, following ETCCDI
definition CSDI.
}
\examples{
# Daily data with minimum temperature
set.seed(123)
daily_data <- data.frame(
  date = seq(as.Date("2000-01-01"), as.Date("2002-12-31"), by = "day"),
  tmin = 15 + 8 * sin(seq(0, 4*pi, length.out = 1096)) + rnorm(1096, 0, 3)
)

calculate_CSDI(
  df = daily_data,
  frequency = "daily",
  time_col = "date",
  tmin_col = "tmin"
)

# With custom window and consecutive days
calculate_CSDI(
  df = daily_data,
  frequency = "daily",
  time_col = "date",
  tmin_col = "tmin",
  window_days = 15,
  min_consecutive = 5
)
}
