% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/go.R
\name{go_code}
\alias{go_code}
\title{Send a Code String to Tidy Data Tutor}
\usage{
go_code(code)
}
\arguments{
\item{code}{A string of R code.}
}
\value{
A string with an appropriately formatted URL to Tidy Data Tutor
(invisibly).
}
\description{
Send a Code String to Tidy Data Tutor
}
\examples{
\dontrun{

code =
"library(dplyr)
library(palmerpenguins)

penguins \%>\%
  select(species, bill_length_mm) \%>\%
  group_by(species) \%>\%
  arrange(desc(bill_length_mm), .by_group = TRUE) \%>\%
  slice(1)"

tidydatatutor::go_code(code)
}
}
