% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ild_prepare.R
\name{ild_prepare}
\alias{ild_prepare}
\title{Prepare a data frame as an ILD (intensive longitudinal data) object}
\usage{
ild_prepare(
  data,
  id,
  time,
  gap_threshold = Inf,
  duplicate_handling = c("first", "last", "error", "collapse"),
  collapse_fn = NULL
)
}
\arguments{
\item{data}{A data frame or tibble with at least an id and a time column.}

\item{id}{Character. Name of the subject/unit identifier column.}

\item{time}{Character. Name of the time column (Date, POSIXct, or numeric).}

\item{gap_threshold}{Numeric. Time distance above which an interval is
flagged as a gap (`.ild_gap` TRUE). Same units as the numeric time
(e.g. seconds if time is POSIXct). Use `Inf` to disable gap flagging.}

\item{duplicate_handling}{Character. How to handle duplicate timestamps
within the same id: `"first"` (keep first), `"last"` (keep last),
`"error"` (stop with an error), `"collapse"` (aggregate with \code{collapse_fn}).}

\item{collapse_fn}{Named list of functions, one per variable to collapse.
Used only when \code{duplicate_handling = "collapse"}. E.g. \code{list(x = mean, y = function(z) z[1])}.
Variables not in \code{collapse_fn} keep their first value within the duplicate group.}
}
\value{
An ILD tibble with `.ild_*` columns and metadata attributes.
  Spacing metadata (see [ild_meta()]) includes overall stats and a
  \code{by_id} tibble of per-person spacing stats (median_dt, iqr_dt,
  n_intervals, pct_gap). Use [ild_summary()] to inspect and check gap
  flags before modeling.
}
\description{
Validates and encodes longitudinal structure: parses time, sorts by id and
time, handles duplicate timestamps, and adds internal columns (`.ild_*`)
and metadata. All downstream functions assume the result of `ild_prepare()`.
}
