% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_helpers.R
\name{varN_fctr_reorder}
\alias{varN_fctr_reorder}
\title{Re-order Factor Levels by VARN}
\usage{
varN_fctr_reorder(data)
}
\arguments{
\item{data}{a dataframe, including one enriched with SAS labels attributes}
}
\value{
The data frame after having factor levels re-ordered by VARN
}
\description{
Function to that looks for VARN counterparts to any character or factor VAR
variables in any dataframe and re-orders there factor levels, taking the lead
from VARN's numeric guide.
}
\examples{
data(adae, package = "tidyCDISC")

varN_fctr_adae <- varN_fctr_reorder(adae)

unique(adae[,c("AGEGR1", "AGEGR1N")])
levels(adae$AGEGR1)
levels(varN_fctr_adae$AGEGR1)

unique(adae[,c("RACE", "RACEN")])
levels(adae$RACE)
levels(varN_fctr_adae$RACE)
}
\keyword{helpers}
