% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abc.R
\name{abc}
\alias{abc}
\title{ABC classification function}
\usage{
abc(.data, category_values, .value)
}
\arguments{
\item{.data}{tibble or dbi object (either grouped or ungrouped)}

\item{category_values}{vector of break points between 0 and 1}

\item{.value}{optional: if left blank,\code{\link[=abc]{abc()}} will use the number of rows per group to categorize, alternatively you can pass a column name to categorize}
}
\value{
abc object
}
\description{
\itemize{
\item For your group variable, \code{\link[=abc]{abc()}}  will categorize which groups make up what proportion of the totals according to the category_values that you have entered
\item The function returns a segment object which prints out the execution steps and actions that it will take to categorize your data
\item Use \link{calculate} to return the results
}
}
\details{
\itemize{
\item This function is helpful to understand which groups of make up what proportion of the cumulative contribution
\item If you do not provide a \code{.value} then it will count the transactions per group, if you provide \code{.value} then it will \code{\link[=sum]{sum()}} the \code{.value} per group
\item The function creates a \code{segment} object, which pre-processes the data into its components
}
}
\examples{
\donttest{
contoso::sales |>
  dplyr::group_by(product_key) |>
  abc(c(.1,.5,.7,.96,1), .value = margin)
}

}
