% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniformly_functions.R
\name{runif_ellipsoid}
\alias{runif_ellipsoid}
\alias{runif_on_ellipse}
\alias{runif_on_ellipsoid}
\alias{runif_in_ellipsoid}
\title{Uniform sampling on/in ellipsoid}
\usage{
runif_on_ellipse(n, A, r)

runif_on_ellipsoid(n, A, r)

runif_in_ellipsoid(n, A, r)
}
\arguments{
\item{n}{number of simulations}

\item{A}{symmetric positive-definite matrix defining the ellipsoid (see
Details), of size 2 for \code{runif_on_ellipse} and size 2 or 3 for
\code{runif_on_ellipsoid} (for size 2 these are the same functions)}

\item{r}{"radius" (see Details)}
}
\value{
The simulations in a matrix with \code{n} rows.
}
\description{
Uniform sampling on an ellipsoid or in an ellipsoid.
  The sampling \emph{in} an ellipsoid is available in arbitrary
  dimension. The sampling \emph{on} an ellipsoid is available only in
  dimension 2 or 3.
  This code is borrowed directly from the uniformly package
  (https://CRAN.R-project.org/package=uniformly)
}
\details{
The ellipsoid is the set of vectors \code{x} satisfying
  \code{t(x) \%*\% A \%*\% x == r^2}. For example, for an axis-aligned
  ellipse with horizontal radius \code{a} and vertical radius \code{b}, take
  \code{A=1/diag(c(a^2,b^2))} and \code{r=1}.
}
\keyword{internal}
