% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{tfd_bates}
\alias{tfd_bates}
\title{Bates distribution.}
\usage{
tfd_bates(
  total_count,
  low = 0,
  high = 1,
  validate_args = FALSE,
  allow_nan_stats = TRUE,
  name = "Bates"
)
}
\arguments{
\item{total_count}{Non-negative integer-valued \code{Tensor} with shape broadcastable
to the batch shape \verb{[N1,..., Nm]}, \code{m >= 0}. This controls the number of
samples of \code{Uniform(low, high)} to take the mean of.}

\item{low}{Floating point \code{Tensor} representing the lower bounds of the support.
Should be broadcastable to \verb{[N1,..., Nm]} with \code{m >= 0}, the same dtype
as \code{total_count}, and \code{low < high} component-wise, after broadcasting.
Defaults to \code{0}.}

\item{high}{Floating point \code{Tensor} representing the upper bounds of the
support.  Should be broadcastable to \verb{[N1,..., Nm]} with \code{m >= 0}, the
same dtype as \code{total_count}, and \code{low < high} component-wise, after
broadcasting.  Defaults to \code{1}.}

\item{validate_args}{Logical, default FALSE. When TRUE distribution parameters are checked
for validity despite possibly degrading runtime performance. When FALSE invalid inputs may
silently render incorrect outputs. Default value: FALSE.}

\item{allow_nan_stats}{Logical, default TRUE. When TRUE, statistics (e.g., mean, mode, variance)
use the value NaN to indicate the result is undefined. When FALSE, an exception is raised if
one or more of the statistic's batch members are undefined.}

\item{name}{name prefixed to Ops created by this class.}
}
\value{
a distribution instance.
}
\description{
The Bates distribution is the distribution of the average of \code{total_count}
independent samples from \code{Uniform(low, high)}. It is parameterized by the
interval bounds \code{low} and \code{high}, and \code{total_count}, the number of samples.
Although some care has been taken to avoid numerical issues, the \code{pdf}, \code{cdf},
and log versions thereof may still exhibit numerical instability. They are
relatively stable near the tails; however near the mode they are unstable if
\code{total_count} is greater than about \code{75} for \code{tf$float64}, \code{25} for
\code{tf$float32}, and \code{7} for \code{tf$float16}. Beyond these limits a warning will be
shown if \code{validate_args=FALSE}; otherwise an exception is thrown. For high
\code{total_count}, consider using a \code{Normal} approximation.
}
\details{
Mathematical Details

The probability density function (pdf) is supported in the interval
\verb{[low, high]}. If \verb{[low, high]} is the unit interval \verb{[0, 1]}, the pdf
is,

\if{html}{\out{<div class="sourceCode">}}\preformatted{pdf(x; n, 0, 1) = ((n / (n-1)!) sum_\{k=0\}^j (-1)^k (n choose k) (nx - k)^\{n-1\}
}\if{html}{\out{</div>}}

where
\itemize{
\item \code{total_count = n},
\item \code{j = floor(nx)}
\item \verb{n!} is the factorial of \code{n},
\item \verb{(n choose k)} is the binomial coefficient \verb{n! / (k!(n - k)!)}
For arbitrary intervals \verb{[low, high]}, the pdf is,
}

\if{html}{\out{<div class="sourceCode">}}\preformatted{pdf(x; n, low, high) = pdf((x - low) / (high - low); n, 0, 1) / (high - low)
}\if{html}{\out{</div>}}
}
\seealso{
For usage examples see e.g. \code{\link[=tfd_sample]{tfd_sample()}}, \code{\link[=tfd_log_prob]{tfd_log_prob()}}, \code{\link[=tfd_mean]{tfd_mean()}}.

Other distributions: 
\code{\link{tfd_autoregressive}()},
\code{\link{tfd_batch_reshape}()},
\code{\link{tfd_bernoulli}()},
\code{\link{tfd_beta}()},
\code{\link{tfd_beta_binomial}()},
\code{\link{tfd_binomial}()},
\code{\link{tfd_categorical}()},
\code{\link{tfd_cauchy}()},
\code{\link{tfd_chi}()},
\code{\link{tfd_chi2}()},
\code{\link{tfd_cholesky_lkj}()},
\code{\link{tfd_continuous_bernoulli}()},
\code{\link{tfd_deterministic}()},
\code{\link{tfd_dirichlet}()},
\code{\link{tfd_dirichlet_multinomial}()},
\code{\link{tfd_empirical}()},
\code{\link{tfd_exp_gamma}()},
\code{\link{tfd_exp_inverse_gamma}()},
\code{\link{tfd_exponential}()},
\code{\link{tfd_gamma}()},
\code{\link{tfd_gamma_gamma}()},
\code{\link{tfd_gaussian_process}()},
\code{\link{tfd_gaussian_process_regression_model}()},
\code{\link{tfd_generalized_normal}()},
\code{\link{tfd_geometric}()},
\code{\link{tfd_gumbel}()},
\code{\link{tfd_half_cauchy}()},
\code{\link{tfd_half_normal}()},
\code{\link{tfd_hidden_markov_model}()},
\code{\link{tfd_horseshoe}()},
\code{\link{tfd_independent}()},
\code{\link{tfd_inverse_gamma}()},
\code{\link{tfd_inverse_gaussian}()},
\code{\link{tfd_johnson_s_u}()},
\code{\link{tfd_joint_distribution_named}()},
\code{\link{tfd_joint_distribution_named_auto_batched}()},
\code{\link{tfd_joint_distribution_sequential}()},
\code{\link{tfd_joint_distribution_sequential_auto_batched}()},
\code{\link{tfd_kumaraswamy}()},
\code{\link{tfd_laplace}()},
\code{\link{tfd_linear_gaussian_state_space_model}()},
\code{\link{tfd_lkj}()},
\code{\link{tfd_log_logistic}()},
\code{\link{tfd_log_normal}()},
\code{\link{tfd_logistic}()},
\code{\link{tfd_mixture}()},
\code{\link{tfd_mixture_same_family}()},
\code{\link{tfd_multinomial}()},
\code{\link{tfd_multivariate_normal_diag}()},
\code{\link{tfd_multivariate_normal_diag_plus_low_rank}()},
\code{\link{tfd_multivariate_normal_full_covariance}()},
\code{\link{tfd_multivariate_normal_linear_operator}()},
\code{\link{tfd_multivariate_normal_tri_l}()},
\code{\link{tfd_multivariate_student_t_linear_operator}()},
\code{\link{tfd_negative_binomial}()},
\code{\link{tfd_normal}()},
\code{\link{tfd_one_hot_categorical}()},
\code{\link{tfd_pareto}()},
\code{\link{tfd_pixel_cnn}()},
\code{\link{tfd_poisson}()},
\code{\link{tfd_poisson_log_normal_quadrature_compound}()},
\code{\link{tfd_power_spherical}()},
\code{\link{tfd_probit_bernoulli}()},
\code{\link{tfd_quantized}()},
\code{\link{tfd_relaxed_bernoulli}()},
\code{\link{tfd_relaxed_one_hot_categorical}()},
\code{\link{tfd_sample_distribution}()},
\code{\link{tfd_sinh_arcsinh}()},
\code{\link{tfd_skellam}()},
\code{\link{tfd_spherical_uniform}()},
\code{\link{tfd_student_t}()},
\code{\link{tfd_student_t_process}()},
\code{\link{tfd_transformed_distribution}()},
\code{\link{tfd_triangular}()},
\code{\link{tfd_truncated_cauchy}()},
\code{\link{tfd_truncated_normal}()},
\code{\link{tfd_uniform}()},
\code{\link{tfd_variational_gaussian_process}()},
\code{\link{tfd_vector_diffeomixture}()},
\code{\link{tfd_vector_exponential_diag}()},
\code{\link{tfd_vector_exponential_linear_operator}()},
\code{\link{tfd_vector_laplace_diag}()},
\code{\link{tfd_vector_laplace_linear_operator}()},
\code{\link{tfd_vector_sinh_arcsinh_diag}()},
\code{\link{tfd_von_mises}()},
\code{\link{tfd_von_mises_fisher}()},
\code{\link{tfd_weibull}()},
\code{\link{tfd_wishart}()},
\code{\link{tfd_wishart_linear_operator}()},
\code{\link{tfd_wishart_tri_l}()},
\code{\link{tfd_zipf}()}
}
\concept{distributions}
