% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_ops.R
\name{img_translate}
\alias{img_translate}
\title{Translate}
\usage{
img_translate(images, translations, interpolation = "NEAREST", name = NULL)
}
\arguments{
\item{images}{A tensor of shape (num_images, num_rows, num_columns, num_channels) (NHWC),
(num_rows, num_columns, num_channels) (HWC), or (num_rows, num_columns) (HW). The rank must
be statically known (the shape is not TensorShape(None)).}

\item{translations}{A vector representing [dx, dy] or (if images has rank 4) a matrix of
length num_images, with a [dx, dy] vector for each image in the batch.}

\item{interpolation}{Interpolation mode. Supported values: "NEAREST", "BILINEAR".}

\item{name}{The name of the op.}
}
\value{
Image(s) with the same type and shape as `images`, translated by the
given vector(s). Empty space due to the translation will be filled with zeros.
}
\description{
Translate image(s) by the passed vectors(s).
}
\section{Raises}{

TypeError: If `images` is an invalid type.
}

