% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rng.R
\name{tf_jiggle}
\alias{tf_jiggle}
\alias{tf_sparsify}
\title{Make a \code{tf} (more) irregular}
\usage{
tf_jiggle(f, amount = 0.4, ...)

tf_sparsify(f, dropout = 0.5, ...)
}
\arguments{
\item{f}{a \code{tfd} object}

\item{amount}{how far away from original grid points can the new grid points
lie, at most (relative to original distance to neighboring grid points).
Defaults to at most 40\% (0.4) of the original grid distances. Must be lower
than 0.5}

\item{...}{additional args for the returned \code{tfd} in \code{tf_jiggle}}

\item{dropout}{how many values of \code{f} to drop, defaults to 50\%.}
}
\value{
an (irregular) \code{tfd} object
}
\description{
Randomly create some irregular functional data from regular ones.
\strong{jiggle} it by randomly moving around its \code{arg}-values. Only for \code{tfd}.
\strong{sparsify} it by setting (100*\code{dropout})\% of its values to \code{NA}.
}
\seealso{
Other tidyfun RNG functions: 
\code{\link{tf_rgp}()}

Other tidyfun RNG functions: 
\code{\link{tf_rgp}()}
}
\concept{tidyfun RNG functions}
