% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_searching.R
\name{grab.fragments}
\alias{grab.fragments}
\title{Grab all fragments in a corpus with given phrase.}
\usage{
grab.fragments(phrase, corp, char.before = 80,
  char.after = char.before, cap.phrase = TRUE, clean = FALSE)
}
\arguments{
\item{phrase}{Phrase to find in corpus}

\item{corp}{is a tm corpus}

\item{char.before}{Number of characters of document to pull before phrase to give 
context.}

\item{char.after}{As above, but trailing characters.  Defaults to char.before value.}

\item{cap.phrase}{TRUE if the phrase should be put in ALL CAPS.  False if left alone.}

\item{clean}{True means drop all documents without phrase from list. False means leave
NULLs in the list.}
}
\value{
fragments in corp that have given phrase.List of lists.  First list is 
      len(corp) long
 with NULL values for documents without phrase, and lists
  of phrases for those documents with the phrase
}
\description{
Search corpus for passed phrase, using some wildcard notation.  Return snippits
of text containing this phrase, with a specified number of characters before and
after.  This gives context for phrases in documents.

Use like this \code{frags = grab.fragments( "israel", bigcorp )}

Can take phrases such as 'appl+' which means any word starting with "appl."  
Can also take phrases such as "big * city" which consist of any three-word phrase with "big" 
as the first word and "city" as the third word.

If a pattern matches overlapping phrases, it will return the first but not 
the second.
}
\examples{
library( tm )
docs = c( "987654321 test 123456789", "987654321 test test word 123456789", 
       "test at start", "a test b", "this is a test", "without the t-word",
       "a test for you and a test for me" )
corpus <- VCorpus(VectorSource(docs))
grab.fragments( "test *", corpus, char.before=4, char.after=4 )
}
