% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text.table.R
\name{as.text.table}
\alias{as.text.table}
\title{Convert a data.table column of character vectors into a column with one row per word grouped by a grouping column.
Optionally will split a column of strings into vectors of constituents.}
\usage{
as.text.table(x, text, split = NULL, group_by = NULL)
}
\arguments{
\item{x}{A data.table.}

\item{text}{A string, the name of the column in x containing text to un-nest.}

\item{split}{A string with a pattern to split the text in text column into constituent parts.}

\item{group_by}{A vector of column names to group by. Doesn't work if the group by column is a list column.}
}
\value{
A data.table, text column un-nested to one row per word.
}
\description{
Convert a data.table column of character vectors into a column with one row per word grouped by a grouping column.
Optionally will split a column of strings into vectors of constituents.
}
\examples{
as.text.table(
  x = as.data.table(
    list(
      col1 = c(
        "a",
        "b"
      ),
      col2 = c(
        tolower("The dog is nice because it picked up the newspaper."),
        tolower("The dog is extremely nice because it does the dishes.")
      )
    )
  ),
  text = "col2",
  split = " "
)
}
