% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repair-terms.R
\name{repair_terms}
\alias{repair_terms}
\title{Repair Terms}
\usage{
repair_terms(x, normalize = TRUE)
}
\arguments{
\item{x}{The object.}

\item{normalize}{A flag specifying whether to normalize terms.}
}
\value{
The repaired term vector.
}
\description{
Repairs a terms vector.
}
\details{
Invalid elements are replaced by missing values and spaces removed.
}
\examples{
repair_terms(new_term(c("b[3]", "b")))
repair_terms(new_term(c("a[3]", "b[1]")))
repair_terms(new_term(c("a [3]", " b [ 1  ] ")))
repair_terms(new_term(c("a", NA)))
}
\seealso{
\code{\link[=term-vector]{term-vector()}}, \code{\link[=valid_term]{valid_term()}} and \code{\link[=normalize_terms]{normalize_terms()}}
}
