% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reconstruct.R
\name{reconstructTensorBF}
\alias{reconstructTensorBF}
\title{Reconstruct the data based on posterior samples}
\usage{
reconstructTensorBF(res)
}
\arguments{
\item{res}{The model object from function \code{\link{tensorBF}}.}
}
\value{
The reconstructed data, a tensor of the size equivalent to the
data on which the model was run.
}
\description{
\code{reconstructTensorBF} returns the reconstruction of the data based on
posterior samples of a given run. The function reconstructs the tensor for
each posterior sample and then computes the expected value.
The reconstruction is returned in the un-normalized space if \code{res$pre}
contains appropriate preprocessing information.
}
\examples{
#Data generation
K <- 3
X <- matrix(rnorm(20*K),20,K)
W <- matrix(rnorm(30*K),30,K)
U <- matrix(rnorm(3*K),3,K)
Y = 0
for(k in 1:K) Y <- Y + outer(outer(X[,k],W[,k]),U[,k])
 Y <- Y + array(rnorm(20*30*3,0,0.25),dim=c(20,30,3))

#Run the method with default options and reconstruct the model's representation of the tensor
\dontrun{res <- tensorBF(Y)}
\dontrun{recon = reconstructTensorBF(res)}
\dontrun{inds = sample(prod(dim(Y)),100)}
\dontrun{plot(Y[inds],recon[inds],xlab="obs",ylab="recon",main=round(cor(Y[inds],recon[inds]),2))}
}
