## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  fig.width  = 7.1,
  fig.height = 3.5,
  comment = "#>"
)


## -----------------------------------------------------------------------------
library(tempdisagg)
data(swisspharma)
plot(sales.a)

## -----------------------------------------------------------------------------
m1 <- td(sales.a ~ 1, to = "quarterly", method = "denton-cholette")

## -----------------------------------------------------------------------------
plot(predict(m1))

## -----------------------------------------------------------------------------
plot(exports.q)
m2 <- td(sales.a ~ 0 + exports.q, method = "denton-cholette")

## -----------------------------------------------------------------------------
plot(predict(m2))

## -----------------------------------------------------------------------------
m3 <- td(sales.a ~ exports.q)

## -----------------------------------------------------------------------------
summary(m3)

## -----------------------------------------------------------------------------
td(sales.a ~ exports.q, truncated.rho = -1)

## -----------------------------------------------------------------------------
plot(predict(m3))

## -----------------------------------------------------------------------------
m4 <- td(formula = sales.a ~ exports.q + imports.q)
summary(m4)

## -----------------------------------------------------------------------------
plot(sales.q)
lines(predict(m2), col = "blue") # Denton-Cholette
lines(predict(m3), col = "red") # Chow-Lin

