% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pb_distance.R
\name{distance_from_pb}
\alias{distance_from_pb}
\title{Distance from plate boundary}
\usage{
distance_from_pb(x, PoR, pb, tangential = FALSE, km = FALSE, ...)
}
\arguments{
\item{x}{\code{sf} or \code{data.frame} objects of the data points in geographical
coordinate system}

\item{PoR}{Pole of Rotation. \code{"data.frame"} or object of class \code{"euler.pole"}
containing the geographical coordinates of the Pole of Rotation}

\item{pb}{\code{sf} objects of the  plate boundary
geometries in the geographical coordinate system}

\item{tangential}{Logical. Whether the plate boundary is a tangential
boundary (\code{TRUE}) or an inward and outward boundary (\code{FALSE}, the
default).}

\item{km}{Logical. Whether the distance is expressed in kilometers
(\code{TRUE}) or in degrees (\code{FALSE}, the default).}

\item{...}{optional arguments passed to \code{\link[smoothr:densify]{smoothr::densify()}}}
}
\value{
Numeric vector of the great circle distances in units defined by \code{km}.
}
\description{
Absolute distance of data points from the nearest plate boundary
}
\details{
The distance to the plate boundary is the longitudinal or
latitudinal difference between the data point and the plate boundary
(along the closest latitude or longitude) for inward/outward or tangential
plate boundaries, respectively.
}
\note{
Stresses emanate from the plate boundary along great circles, small
circles or loxodromes associated with the pole of rotation.
Hence the emanation distance is not necessarily the shortest distance to the
plate boundary, which is measured along a great circle unrelated to the pole
of rotation. The differences are particularly notable when the plate boundary
is kinked or for convergent and divergent plate boundaries.
}
\examples{
data("nuvel1")
na_pa <- subset(nuvel1, nuvel1$plate.rot == "na")

data("plates")
plate_boundary <- subset(plates, plates$pair == "na-pa")

data("san_andreas")
res <- distance_from_pb(
  x = san_andreas, PoR = na_pa, pb = plate_boundary, tangential = TRUE
)
head(res)

res.km <- distance_from_pb(
  x = san_andreas, PoR = na_pa, pb = plate_boundary, tangential = TRUE, km = TRUE
)
range(res.km)
}
\references{
Wdowinski, S. (1998). A theory of intraplate tectonics. Journal
of Geophysical Research: Solid Earth, 103(3), 5037<U+2013>5059.
http://dx.doi.org/10.1029/97JB03390
}
