% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qenv-eval_code.R
\name{eval_code}
\alias{eval_code}
\alias{eval_code,qenv-method}
\alias{eval_code,qenv.error-method}
\title{Evaluate code in \code{qenv}}
\usage{
eval_code(object, code, ...)
}
\arguments{
\item{object}{(\code{qenv})}

\item{code}{(\code{character}, \code{language} or \code{expression}) code to evaluate.
It is possible to preserve original formatting of the \code{code} by providing a \code{character} or an
\code{expression} being a result of \code{parse(keep.source = TRUE)}.}

\item{...}{(\code{\link{dots}}) additional arguments passed to future methods.}
}
\value{
\code{qenv} environment with \code{code/expr} evaluated or \code{qenv.error} if evaluation fails.
}
\description{
Evaluate code in \code{qenv}
}
\details{
\code{eval_code()} evaluates given code in the \code{qenv} environment and appends it to the \code{code} slot.
Thus, if the \code{qenv} had been instantiated empty, contents of the environment are always a result of the stored code.
}
\examples{
# evaluate code in qenv
q <- qenv()
q <- eval_code(q, "a <- 1")
q <- eval_code(q, "b <- 2L # with comment")
q <- eval_code(q, quote(library(checkmate)))
q <- eval_code(q, expression(assert_number(a)))

}
\seealso{
\link{within.qenv}
}
