% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_tapnet.R
\name{internalFunctions}
\alias{internalFunctions}
\alias{helper}
\alias{functions}
\alias{pems_from_tree}
\alias{select_relevant_pems}
\alias{tmatch}
\alias{param_vec2list}
\alias{loglik_tapnet}
\alias{latent_cor}
\alias{web_indices}
\alias{refit_params}
\title{Helper functions for tapnet}
\usage{
internalFunctions()

pems_from_tree(tree)

select_relevant_pems(tree, species)

tmatch(delta_t, type = "normal", width = 1, shift = 0, err = 1e-05)

param_vec2list(params, n, m, fit.delta = FALSE)

loglik_tapnet(
  params,
  networks,
  tmatch_type_pem,
  tmatch_type_obs,
  lambda = 0,
  obj_function = "multinom",
  fit.delta = TRUE
)

latent_cor(true_pars, fitted_pars, pems_low, pems_high)

web_indices(web, web_dim, indices)

refit_params(tapnet, fit, fitted_I_mat)
}
\arguments{
\item{tree}{phylogenetic tree in phylo format;}

\item{species}{a named vector of species, representing (some of) the tips of the phylogenetic tree;}

\item{delta_t}{vector of pairwise trait differences (higher - lower);}

\item{type}{trait matching function: either "normal" or "shiftlnorm";}

\item{width}{width parameter of trait matching function, similar to sd in the normal;}

\item{shift}{shift parameter (optimum trait distance), currently ignored in fitting;}

\item{err}{"baseline" probability of match, even if traits do not match at all;}

\item{params}{parameter vector with setting for tapnet simulation;}

\item{n}{number of latent trait linear combination parameters (lower level);}

\item{m}{number of latent trait linear combination parameters (higher level);}

\item{fit.delta}{logical; should the trait-weighting exponent delta be fitted?}

\item{networks}{the "networks" part of a tapnet object;}

\item{tmatch_type_pem}{type of trait matching function for latent traits;}

\item{tmatch_type_obs}{type(s) of trait matching functions for observed traits; can be a vector as long as there are traits;}

\item{lambda}{LASSO shrinkage parameter to avoid collinearity issues when observed traits are phylogenetically correlated;}

\item{obj_function}{objective function, either "multinom" or anything else (currently anything else leads to OLS fitting);}

\item{true_pars}{parameters used for simulating the network;}

\item{fitted_pars}{parameters estimated by \code{\link{fit_tapnet}};}

\item{pems_low}{phylogenetic eigenvectors for the lower trophic level;}

\item{pems_high}{phylogenetic eigenvectors for the higher trophic level;}

\item{web}{data for an interaction network in vector form, e.g. from predict_tapnet;}

\item{web_dim}{vector of two numbers indicating the rows and column of the network matrix;}

\item{indices}{vector of names of network indices to compute; see \code{\link[bipartite]{networklevel}} for what is available;}

\item{tapnet}{a tapnet object;}

\item{fit}{a fitted tapnet;}

\item{fitted_I_mat}{the fitted I-matrix of a fitted tapnet object (I think).}
}
\description{
Lower-level, non-exported functions to be called by the main tapnet functions
}
\details{
They do roughly the following: 
\describe{
  \item{\code{pems_from_tree}}{computes phylogenetic eigenvectors from a phylogenetic tree;}
  \item{\code{select_relevant_pems}}{identifies those phylogenetic eigenvectors (PEMs) of the full tree most relevant for a network containing only a subset of species;}
  \item{\code{tmatch}}{calculates interaction probabilities based on trait matching;}
  \item{\code{param_vec2list}}{converts a vector of parameters (for trait matching and latent trait combinations) into a named list;}
  \item{\code{loglik_tapnet}}{the log-likelihood function for fitting the tapnet model; actually quite an important function, easy to break, so not for the user to easily access;}
  \item{\code{latent_cor}}{computes correlation of fitted latent with true constructed traits for simulated data;}
  \item{\code{web_indices}}{computes the specified network indices for the provided network, after turning the prediction vector into a matrix;}
  \item{\code{refit_params}}{Simulate new networks from a fitted tapnet object, re-fit on the simulated network and output the parameter values.}
}
}
\references{
Benadi et al. in prep
}
\author{
Gita Benadi <gita.benadi@biom.uni-freiburg.de>, Carsten Dormann <carsten.dormann@biom.uni-freiburg.de> and Jochen Fründ <jochen.fruend@biom.uni-freiburg.de>
}
