% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/txt_recode_fast.R
\name{process_multiwords_fast}
\alias{process_multiwords_fast}
\title{Optimized multiword processing workflow}
\usage{
process_multiwords_fast(x2, stats, term = c("lemma", "token"))
}
\arguments{
\item{x2}{Data frame with token information}

\item{stats}{Data frame with multiword statistics (keyword, ngram columns)}

\item{term}{Type of term to process: "lemma" or "token"}
}
\value{
Data frame with columns: doc_id, term_id, multiword, upos_multiword, ngram
}
\description{
Complete optimized workflow for multiword detection and processing.
Uses C++ functions and data.table for maximum performance.
}
\details{
This function replaces the original switch block with an optimized version
that uses:
\itemize{
\item C++ functions for text recoding
\item Vectorized operations instead of multiple mutate calls
\item Pre-computed lookups to avoid repeated joins
}
}
\examples{
\dontrun{
result <- process_multiwords_fast(dfTag, multiword_stats, term = "lemma")
}

}
