% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Other.R
\docType{package}
\name{tailDepFun}
\alias{tailDepFun}
\title{tailDepFun}
\description{
The package \code{tailDepFun} provides functions implementing two rank-based minimal distance estimation
methods for parametric tail dependence models for distributions attracted to a max-stable law.
The estimators, referred to as the pairwise M-estimator and the weighted least squares estimator, are
described in Einmahl et al. (2016a) and Einmahl et al. (2016b). Extensive examples to illustrate the use
of the package can be found in the accompanying vignette.
}
\details{
Currently, this package allows for estimation of the Brown-Resnick process, the Gumbel (or logistic) model
and max-linear models (possibly on a directed acyclic graph). The main functions of this package are
\code{\link{EstimationBR}}, \code{\link{EstimationGumbel}} and \code{\link{EstimationMaxLinear}},
but several other functions are exported as well: \code{\link{stdfEmpInt}}
returns the integral of the bivariate empirical stable tail dependence function over the unit square, and
\code{\link{stdfEmp}} and \code{\link{stdfEmpCorr}} return the (bias-corrected) empirical stable tail dependence
function. The functions \code{\link{AsymVarBR}}, \code{\link{AsymVarGumbel}}, \code{\link{AsymVarMaxLinear}}
return the asymptotic covariance matrices of the estimators. An auxiliary function to select a regular
grid of indices in which to evaluate the stable tail dependence function is exported as well,
\code{\link{selectGrid}}. Finally, two datasets are available: \code{\link{dataKNMI}} (Einmahl et al., 2016)
and \code{\link{dataEUROSTOXX}} (Einmahl et al., 2018).
}
\examples{
## get a list of all help files of user-visible functions in the package
help(package = tailDepFun)
}
\references{
Einmahl, J.H.J., Kiriliouk, A., Krajina, A., and Segers, J. (2016). An Mestimator of spatial tail dependence. Journal of the Royal Statistical Society: Series B (Statistical Methodology), 78(1), 275-298.

Einmahl, J.H.J., Kiriliouk, A., and Segers, J. (2018). A continuous updating weighted least squares estimator of tail dependence in high dimensions. Extremes 21(2), 205-233.
}
