% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise.R
\name{safe_min}
\alias{safe_min}
\title{Calculate \code{min} but suppress the warning when all values are missing}
\usage{
safe_min(x, na.rm = FALSE)
}
\arguments{
\item{x}{A numerical vector.}

\item{na.rm}{A boolean indicating whether to remove NAs.}
}
\value{
The min of \code{x} or NA when values are missing.
}
\description{
This function is a drop-in replacement for \code{min}, which is used in
\code{cat_summarise}. It suppresses the warning when all values are NA and
na.rm is TRUE, and returns NA instead of Inf.
}
\keyword{internal}
