% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{plot_tree}
\alias{plot_tree}
\title{Make 3-panel plot of tree point cloud to check for errors}
\usage{
plot_tree(las, res = 0.05, plot = TRUE)
}
\arguments{
\item{las}{`LAS` object from `lidR` package representing
the CROWN of a tree. Crowns can be segmented using [segment_crown()].}

\item{res}{numeric - resolution of voxelization to speed up plotting}

\item{plot}{boolean - indicates whether to print the output plot, in
both cases a ggplot object is returned in the output.}
}
\value{
A `ggplot` object containing the arranged diagnostic panels.
}
\description{
Plots 2 profiles X, Y, and and overhead Z view of a point
cloud to allow users to identify stray points, or errors in
segmentations.
}
\examples{
# example code
library(lidR)
file = system.file("extdata", "tree_0744.laz", package="tReeTraits")
las = readLAS(file, filter = '-thin_with_voxel 0.1')
las = clean_las(las)
plot_tree(las)
}
